#ifndef QRK_URG_DRAW_WIDGET_H
#define QRK_URG_DRAW_WIDGET_H

/*!
  \file
  \brief URG データの描画ウィジット

  \author Satofumi KAMIMURA

  $Id: UrgDrawWidget.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "Point.h"
#include "Color.h"
#include <QGLWidget>
#include <memory>


namespace qrk
{
  class RangeSensor;
}


/*!
  \brief URG データの描画用ウィジット
*/
class UrgDrawWidget : public QGLWidget
{
  Q_OBJECT;

  UrgDrawWidget(const UrgDrawWidget& rhs);
  UrgDrawWidget& operator = (const UrgDrawWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void initializeGL(void);
  void resizeGL(int width, int height);
  void paintGL(void);
  void mousePressEvent(QMouseEvent* event);
  void mouseMoveEvent(QMouseEvent* event);
  void mouseReleaseEvent(QMouseEvent* event);
  void wheelEvent(QWheelEvent* event);

public:
  typedef enum {
    Points,
    Lines,
    Polygon,
  } DrawMode;

  enum {
    NoneSpecified = -1,
  };

  UrgDrawWidget(QWidget* parent = 0);
  ~UrgDrawWidget(void);

  void clear(void);
  void initializeView(void);

  void redraw(int timestamp = NoneSpecified);

  bool setUrgData(qrk::RangeSensor* sensor);
  bool setUrgData(std::vector<long>& data,
                  const qrk::RangeSensor* sensor, int timestamp);
  bool setUrgData(std::vector<qrk::Point<long> >& data,
                  int timestamp);

  bool setUrgIntensityData(std::vector<long>& data,
                           const qrk::RangeSensor* sensor, int timestamp);
  bool setUrgIntensityData(std::vector<qrk::Point<long> >& data,
                           int timestamp);

  void setDrawColor(const qrk::Color& line_color);

  void setDrawMode(DrawMode mode);

  void setDrawPeriod(size_t msec);

  void setZoomRatio(double pixel_per_mm);
  double zoomRatio(void);
  void updateZoomRatio(int steps);

  void setViewCenter(const qrk::Point<long>& point);
  qrk::Point<long> viewCenter(void);

signals:
  void position(bool active, long x_mm, long y_mm);
  void scansInterval(int msec);
};

#endif /* !QRK_URG_DRAW_WIDGET_H */
