#ifndef QRK_CONNECTION_WIDGET_SAMPLE_H
#define QRK_CONNECTION_WIDGET_SAMPLE_H

/*!
  \file
  \brief ConnectionWidget の動作確認ウィジット

  \author Satofumi KAMIMURA

  $Id: ConnectionWidgetSample.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "ui_ConnectionWidgetSampleForm.h"
#include <memory>


class ConnectionWidgetSample
  : public QWidget, private Ui::ConnectionWidgetSampleForm
{
  Q_OBJECT;

  ConnectionWidgetSample(const ConnectionWidgetSample& rhs);
  ConnectionWidgetSample& operator = (const ConnectionWidgetSample& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void connectPressed(bool connection, const std::string& device);
  void rescanPressed(void);

public:
  ConnectionWidgetSample(QWidget* parent = 0);
  ~ConnectionWidgetSample(void);
};

#endif /* !QRK_CONNECTION_WIDGET_SAMPLE_H */
