#ifndef QRK_CONNECTION_WIDGET_H
#define QRK_CONNECTION_WIDGET_H

/*!
  \file
  \brief 接続管理ウィジット

  \author Satofumi KAMIMURA

  $Id: ConnectionWidget.h 1005 2009-06-14 12:33:10Z satofumi $
*/

#include "ui_ConnectionWidgetForm.h"
#include <memory>


class ConnectionWidget : public QWidget, private Ui::ConnectionWidgetForm
{
  Q_OBJECT;

  ConnectionWidget(const ConnectionWidget& rhs);
  ConnectionWidget& operator = (const ConnectionWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void connectPressed(bool checked);
  void rescanPressed(void);

public:
  ConnectionWidget(QWidget* parent = 0);
  ~ConnectionWidget(void);

  void setConnected(bool connected);
  bool isConnected(void) const;

  void setDevices(const std::vector<std::string>& devices);
  std::vector<std::string> devices(void);

  void setEnabled(bool enable);
  void setFocus(void);

signals:
  void connectRequest(bool connection, const std::string& device);
  void rescanRequest(void);
};

#endif /*! QRK_CONNECTION_WIDGET_H */
