#ifndef S_FORMAT_HANDLER_H
#define S_FORMAT_HANDLER_H

/*!
  \file
  \brief S-Format ファイルの解析

  \author Satofumi KAMIMURA

  $Id: SformatHandler.h 1402 2009-10-11 12:45:16Z satofumi $
*/

#include <vector>
#include <string>
#include <memory>


namespace qrk
{
  //! S-Format の処理クラス
  class SformatHandler
  {
    SformatHandler(void);
    SformatHandler(const SformatHandler& rhs);
    SformatHandler& operator = (const SformatHandler& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    //! S-Format の型
    typedef struct
    {
      char type;
      unsigned long address;
      std::vector<char> data;
    } sformat_t;

    SformatHandler(const char* file);
    ~SformatHandler(void);

    const char* what(void) const;

    bool invalid(void) const;

    //! S-Format の解析
    static bool parseSformat(sformat_t* sformat, const std::string& line);
  };
}

#endif /* !S_FORMAT_HANDLER_H */
