#ifndef F_ZTAT_TRANSFER_H
#define F_ZTAT_TRANSFER_H

/*!
  \file
  \brief F-ZTAT の処理

  \author Satofumi KAMIMURA

  $Id: FZtatHandler.h 1386 2009-10-09 08:00:11Z satofumi $
*/

#include <memory>

namespace qrk
{
  class Connection;
}


//! F-ZTAT の処理クラス
class FZtatHandler
{
  FZtatHandler(const FZtatHandler& rhs);
  FZtatHandler& operator = (const FZtatHandler& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  FZtatHandler(void);
  virtual ~FZtatHandler(void);

  virtual void progress(double percent)
  {
    static_cast<void>(percent);
  }

  const char* what(void) const;

  bool transfer(qrk::Connection* connection,
                const char* writer_program, size_t send_size);
};

#endif /* !F_ZTAT_TRANSFER_H */
