#!/usr/bin/ruby
# Makefile  Makefile.am 륹ץ
# Satofumi KAMIMURA
# $Id: amgen.rb 817 2009-05-07 16:06:45Z satofumi $
# ŪˡMakefile.am  <program>_SOURCES ФɲäΤߤԤ
#
# \todo symlink ¸ߤƤ⥨顼ˤʤʤ褦ˤ

require 'fileutils.rb'

# Makefile.am  _SOURCES ιܤ
$sources_list = []

# ե򥤥󥯥롼ɥѥõcpp ɲä
def searchAndRegister(add_file, include_pathes)

  #p include_pathes

  # ե뤬 include_pathes ¸ߤ뤫õ
  file_rpath = nil
  include_pathes.each { |rpath|
    # ե¸߳ǧ
    if File.exist?(rpath + add_file)
      file_rpath = rpath
      break
    end
  }
  if file_rpath == nil
    return false
  end
  add_file_path = file_rpath + add_file
  add_files = [ add_file_path ]

  # Ʊ cpp ¸ߤ뤫ǧ
  add_also_cpp = nil
  if File.extname(add_file) != '.cpp'
    check_file = file_rpath + File.basename(add_file, '.*') + '.cpp'
    if File.exist?(check_file)
      add_files.push(check_file)
    end
  end

  # No such file or directory ʤϤʤΤǡܥå󥯤
  add_files.each { |file|
    File.symlink(file, File.basename(file))
  }

  # Makefile.am ɵ⡼ɤǳɵԤ
  File.open('Makefile.am', 'a') { |io|
    add_files.each { |file|
      add_basename = File.basename(file)
      if add_files.assoc(add_basename) == nil
        io.write(' ' + add_basename)
        $sources_list.push(add_basename)
      end
    }
  }

  return true
end

# ----- ᥤ -----
# ʤСȤɽƽλ
if ARGV.size <= 0
  print "usage:\n\t" + __FILE__ + " <Makefile>\n\n"
  exit
end

# ѡν
makefile = ARGV[0]
makefile_rpath = File.dirname(makefile) + '/' # Makefile ؤХѥ
include_pathes = []

# ϤΥե Makefile ȸʤɤ߽Ф
File.open(makefile) { |io|
  while line = io.gets

    # INCLUDE ΥѥȴФ
    if line =~ /^INCLUDES = (.+)/
      includes = Regexp.last_match[1].split(' ')
      includes.each { |include|
        include_pathes.push(makefile_rpath + include[2, 128] + '/')
      }
      # Makfile ΤɲäƤ
      include_pathes.push(makefile_rpath)
    end

    # REQUIRE_LIBS Υѥ⡢õѥ˴ޤ
    if line =~ /^REQUIRE_LIBS = (.+)/
      require_libs = Regexp.last_match[1].split(' ')
      require_libs.each { |lib|
        include_pathes.push(makefile_rpath + File.dirname(lib) + '/')
      }
    end
  end
}

# Makefile.am ΥХååפäƤ
FileUtils.copy('Makefile.am', 'Makefile.am.bak')

# Makefile.am 顢SOURCES ϿѤߤΥեȴФ
File.open('Makefile.am') { |io|
  while line = io.gets
    if line =~ /_SOURCES = (.+)/
      $sources_list = Regexp.last_match[1].split(' ')
    end
  end
}

# make ¹ԤĤʤեɲäƤ
begin
  `make 2> errors_output.txt`
  make_status = $?.to_i / 256

  changed = false
  File.open('errors_output.txt') { |io|
    while line = io.gets
      if (line =~ / (.+): No such file or directory/) ||
          (line =~ / (.+): Τ褦ʥեǥ쥯ȥϤޤ/)

           add_file = Regexp.last_match[1]

        # եõɲ
        print 'Adding ' + add_file + ' ... '
        ret = searchAndRegister(add_file, include_pathes)
        if ret
          print "O.K.\n"
        else
          # 顼ˤʤä顢λ
          print "Fail !\n"

          # ѹʤäȤˤƥ롼פȴåɽ
          changed = false
          break;
        end
        changed = true
      end
    end
  }
  if changed == false
    # 顼åɽ뤿ν
    # !!! Ҥɤ...
    # !!! errors_output.txt ΥˤäƤϡｪλȤߤʤ٤
    if make_status != 0
      print "Fail !!\n"
      `make`
    end
  end
end while (make_status != 0) && changed

# եơޤ
FileUtils.remove('errors_output.txt')
