/*!
  \file
  \brief 経路ログの取得

  \author Satofumi KAMIMURA

  $Id: path_recorder.cpp 1448 2009-10-25 14:05:02Z satofumi $

  \todo 複数の取得データをまとめて１つの地図が生成できるようにする
*/

#include <qrk_main.h>
#include <mUrgDevice.h>
#include <mCameraDevice.h>
#include <ticks.h>

using namespace qrk;
using namespace std;

//#define NO_CAMERA


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  mUrgDevice urg;
  if (! urg.connect("/dev/ttyACM0")) {
    cout << "UrgDevice::connect: " << urg.what() << endl;
    return 1;
  }
  //urg.setSkipLines(2);

#ifndef NO_CAMERA
  mCameraDevice camera;
  if (! camera.connect()) {
    cout << "CameraDevice::connect: " << camera.what() << endl;
    return 1;
  }
#endif

  enum { CameraCaptureInterval = 3000 };
  int first_ticks = -CameraCaptureInterval;

  size_t capture_index = 0;
  vector<long> data;
  while (true) {
    // URG データの記録
    urg.requestData();
    int n = urg.receiveData(data);
    if (n <= 0) {
      break;
    }
    cout << ".";

    int current_ticks = ticks();
    if ((current_ticks - first_ticks) > CameraCaptureInterval) {
      first_ticks = current_ticks;

#ifdef NO_CAMERA
      (void)capture_index;
      cout << endl;
#else

      // カメラ画像の記録
      enum { BufferSize = 128 };
      char file_name[BufferSize];
      snprintf(file_name, BufferSize, "camera_%04d.jpg", capture_index);
      camera.capture(file_name);
      ++capture_index;

      cout << current_ticks << " [msec] (" << file_name << ")" << endl;
#endif
    }
  }

  return 0;
}
