#ifndef PLOT_OBJECTS_H
#define PLOT_OBJECTS_H

/*!
  \file
  \brief 描画

  \author Satofumi KAMIMURA

  $Id: plot_objects.h 1451 2009-10-25 21:22:05Z satofumi $
*/

#include <vector>
#include <featurePoint_t.h>
#include <line_t.h>

namespace qrk
{
  class MarkerManager;
  class RangeFinder;
  class Angle;
}


extern void plotLrfData(qrk::MarkerManager& marker,
                        const qrk::RangeFinder& range_finder,
                        const std::vector<long>& data);
extern void plotOriginDirection(qrk::MarkerManager& marker,
                                const qrk::Angle& direction);
extern void plotPolls(qrk::MarkerManager& marker,
                      std::vector<qrk::featurePoint_t>& polls);
extern void plotLines(qrk::MarkerManager& marker,
                      std::vector<qrk::line_t>& lines);

#endif /* !PLOT_OBJECTS_H */
