#ifndef C_CONNECT_THREAD_H
#define C_CONNECT_THREAD_H

/*!
  \file
  \brief 再生時の接続用スレッド

  \author Satofumi KAMIMURA

  $Id: cConnectThread.h 1299 2009-09-15 00:56:12Z satofumi $
*/

#include <QThread>
#include "urg_t.h"
#include <memory>


/*!
  \brief 接続用スレッドクラス
*/
class cConnectThread : public QThread
{
  Q_OBJECT;

  cConnectThread(void);
  cConnectThread(const cConnectThread& rhs);
  cConnectThread& operator = (const cConnectThread& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void run(void);

public:
  cConnectThread(urg_t& urg);
  ~cConnectThread(void);

  void setConnectSettings(const std::string& device, long baudrate);

signals:
  void connected(bool connected);
};

#endif /* !CONNECT_THREAD_H */
