#ifndef C_CAPTURE_SETTING_WIDGET_H
#define C_CAPTURE_SETTING_WIDGET_H

/*!
  \file
  \brief 取得設定ウィジット

  \author Satofumi KAMIMURA

  $Id: cCaptureSettingWidget.h 1299 2009-09-15 00:56:12Z satofumi $
*/

#include "ui_CaptureSettingWidgetForm.h"
#include "urg_t.h"
#include "CaptureSettings.h"
#include <memory>


/*!
  \brief データ取得設定ウィジット
*/
class cCaptureSettingWidget
  : public QWidget, private Ui::CaptureSettingWidgetForm
{
  Q_OBJECT;

  cCaptureSettingWidget(const cCaptureSettingWidget& rhs);
  cCaptureSettingWidget& operator = (const cCaptureSettingWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected slots:
  void applyPressed(void);
  void firstFinished(void);
  void lastFinished(void);
  void isRangeChanged(void);
  void modeChanged(int type);
  void timesChanged(void);
  void quitPressed(void);
  void closeEvent(QCloseEvent* event);
  void lineGroupsChanged(void);
  void frameSkipsChanged(void);
  void captureTimesChanged(void);

public:
  enum {
    InfinityTimes = 100,
  };

  cCaptureSettingWidget(urg_t& urg, QWidget* parent = 0);
  ~cCaptureSettingWidget(void);

  void setIntensityMode(bool enable_cluster = true);

  void setMode(qrk::CaptureType type);
  void setTimes(size_t times);
  void setApplyEnabled(bool enable);
  void setConnected(bool connection);

public slots:
  void loadPressed(void);
  void reconnectCompleted(void);

signals:
  void setCaptureSettings(const qrk::CaptureSettings& settings);
  void reconnectRequest(void);
  void widgetClose(const std::string& widget_name);
  void quit(void);
  void rangeChanged(int first_index, int last_index);
};

#endif /* !C_CAPTURE_SETTING_WIDGET_H */
