#ifndef RANGE_VIEW_WIDGET_H
#define RANGE_VIEW_WIDGET_H

/*!
  \file
  \brief 範囲を 2D 表示するウィジット

  \author Satofumi KAMIMURA

  $Id: RangeViewWidget.h 1438 2009-10-21 16:11:46Z satofumi $
*/

#include <QWidget>
#include <memory>

namespace qrk
{
  class RangeSensorParameter;
}
class CaptureSettingWidget;


/*!
  \brief データ取得範囲の描画ウィジット
*/
class RangeViewWidget : public QWidget
{
  Q_OBJECT;

public:
  RangeViewWidget(CaptureSettingWidget* parent = 0);
  ~RangeViewWidget(void);

  void setParameter(const qrk::RangeSensorParameter& parameter);

protected:
  void paintEvent(QPaintEvent* event);

protected slots:
  void isRangeChanged(int first_index, int last_index);

private:
  RangeViewWidget(const RangeViewWidget& rhs);
  RangeViewWidget& operator = (const RangeViewWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !RANGE_VIEW_WIDGET_H */
