#ifndef LENGTH_VIEW_WIDGET_H
#define LENGTH_VIEW_WIDGET_H

/*!
  \file
  \brief 距離データの閲覧ウィジット

  \author Satofumi KAMIMURA

  $Id: LengthViewWidget.h 1438 2009-10-21 16:11:46Z satofumi $
*/

#include "ui_LengthViewWidgetForm.h"
#include <memory>


/*!
  \brief 距離データ値の描画ウィジット
*/
class LengthViewWidget : public QWidget, private Ui::LengthViewWidgetForm
{
  Q_OBJECT;

public:
  LengthViewWidget(QWidget* parent = 0);
  ~LengthViewWidget(void);

  void clear(void);
  void setMinDistance(size_t min_distance);

  void setLength(const std::vector<long>& length_data);
  void setIntensity(const std::vector<long>& intensity_data);

signals:
  void lengthViewRequest(void);
  void drawLineRequest(const std::vector<int>& indexes);
  void widgetClose(const std::string& widget_name);
  void quit(void);

protected slots:
  void closeEvent(QCloseEvent* event);
  void updatePressed(void);
  void savePressed(void);
  void quitPressed(void);
  void itemSelectionChanged(void);

private:
  LengthViewWidget(const LengthViewWidget& rhs);
  LengthViewWidget& operator = (const LengthViewWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !LENGTH_VIEW_WIDGET_H */
