/*!
  \file
  \brief 再生時の接続用スレッド

  \author Satofumi KAMIMURA

  $Id: ConnectThread.cpp 1298 2009-09-14 20:46:35Z satofumi $
*/

#include "ConnectThread.h"
#include "RangeSensor.h"
#include "mUrgCtrl.h"

using namespace qrk;
using namespace std;


struct ConnectThread::pImpl
{
  RangeSensor& sensor_;

  string device_;
  long baudrate_;


  pImpl(RangeSensor& sensor)
    : sensor_(sensor), device_("dummy"), baudrate_(mUrgCtrl::DefaultBaudrate)
  {
  }
};


void ConnectThread::run(void)
{
  bool ret = pimpl->sensor_.connect(pimpl->device_.c_str(), pimpl->baudrate_);
  emit connected(ret);
}


ConnectThread::ConnectThread(RangeSensor& sensor)
  : pimpl(new pImpl(sensor))
{
}


ConnectThread::~ConnectThread(void)
{
}


void ConnectThread::setConnectSettings(const string& device, long baudrate)
{
  pimpl->device_ = device;
  pimpl->baudrate_ = baudrate;
}
