#ifndef CAPTURE_SETTING_WIDGET_H
#define CAPTURE_SETTING_WIDGET_H

/*!
  \file
  \brief 取得設定ウィジット

  \author Satofumi KAMIMURA

  $Id: CaptureSettingWidget.h 1438 2009-10-21 16:11:46Z satofumi $
*/

#include "ui_CaptureSettingWidgetForm.h"
#include "CaptureSettings.h"
#include <memory>

namespace qrk
{
  class RangeSensor;
}


/*!
  \brief データ取得設定ウィジット
*/
class CaptureSettingWidget
  : public QWidget, private Ui::CaptureSettingWidgetForm
{
  Q_OBJECT;

public:
  enum {
    InfinityTimes = 100,
  };

  CaptureSettingWidget(const qrk::RangeSensor& sensor, QWidget* parent = 0);
  ~CaptureSettingWidget(void);

  void setIntensityMode(bool enable_cluster = true);

  void setMode(qrk::CaptureType type);
  void setTimes(size_t times);
  void setApplyEnabled(bool enable);
  void setConnected(bool connection);

public slots:
  void loadPressed(void);
  void reconnectCompleted(void);

signals:
  void setCaptureSettings(const qrk::CaptureSettings& settings);
  void reconnectRequest(void);
  void widgetClose(const std::string& widget_name);
  void quit(void);
  void rangeChanged(int first_index, int last_index);

protected slots:
  void applyPressed(void);
  void firstFinished(void);
  void lastFinished(void);
  void isRangeChanged(void);
  void modeChanged(int type);
  void timesChanged(void);
  void quitPressed(void);
  void closeEvent(QCloseEvent* event);
  void lineGroupsChanged(void);
  void frameSkipsChanged(void);
  void captureTimesChanged(void);

private:
  CaptureSettingWidget(const CaptureSettingWidget& rhs);
  CaptureSettingWidget& operator = (const CaptureSettingWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !CAPTURE_SETTING_WIDGET_H */
