#ifndef URG_SCANNER_WINDOW_H
#define URG_SCANNER_WINDOW_H

/*!
  \file
  \brief UrgScanner のメインウィンドウ管理

  \author Satofumi KAMIMURA

  $Id: UrgScannerWindow.h 994 2009-06-13 09:29:40Z satofumi $
*/

#include <QMainWindow>
#include "ui_UrgScannerWindowForm.h"
#include <memory>


/*!
  \brief UrgScanner のメインウィンドウ管理クラス
*/
class UrgScannerWindow : public QMainWindow, private Ui::UrgScannerWindow {
  Q_OBJECT;

  UrgScannerWindow(const UrgScannerWindow& rhs);
  UrgScannerWindow& operator = (const UrgScannerWindow& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void connectHandler(bool checked);
  void redrawHandler(void);
  bool meHandler(bool checked);

  void loadVrml(void);
  void saveVrml(void);

public:
  void wheelEvent(QWheelEvent* event);

public:
  UrgScannerWindow(void);
  ~UrgScannerWindow(void);
};

#endif /* !URG_SCANNER_WINDOW_H */
