#ifndef URG_RECORDER_WIDGET_H
#define URG_RECORDER_WIDGET_H

/*!
  \file
  \brief URG データの記録ウィジット

  \author Satofumi KAMIMURA

  $Id: UrgRecorderWidget.h 1096 2009-06-28 19:37:32Z satofumi $
*/

#include "ui_UrgRecorderWidgetForm.h"
#include <memory>


class UrgRecorderWidget : public QWidget, private Ui::UrgRecorderWidgetForm
{
  Q_OBJECT;

  UrgRecorderWidget(const UrgRecorderWidget& rhs);
  UrgRecorderWidget& operator = (const UrgRecorderWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void closeEvent(QCloseEvent* event);
  void rescanPressed(void);
  void connectPressed(bool connection, const std::string& device);
  void recordPressed(void);
  void cancelPressed(void);
  void timesChanged(int times);
  void recordData(void);
  void rawButtonChanged(bool checked);

public:
  UrgRecorderWidget(QWidget* parent = 0);
  ~UrgRecorderWidget(void);
};

#endif /* !URG_RECORDER_WIDGET_H */
