#ifndef RECORD_CONNECTION_H
#define RECORD_CONNECTION_H

/*!
  \file
  \brief 送受信データを記録する Connection クラス

  \author Satofumi KAMIMURA

  $Id: RecordConnection.h 1302 2009-09-15 21:51:30Z satofumi $
*/

#include "Connection.h"
#include <memory>


class RecordConnection : public qrk::Connection
{
  RecordConnection(void);
  RecordConnection(const RecordConnection& rhs);
  RecordConnection& operator = (const RecordConnection& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  RecordConnection(qrk::Connection* connection,
                   const char* send_save_file, const char* receive_save_file);
  ~RecordConnection(void);

  const char* what(void) const;

  bool connect(const char* device, long baudrate);
  void disconnect(void);
  bool setBaudrate(long baudrate);
  long baudrate(void) const;
  bool isConnected(void) const;
  int send(const char* data, size_t count);
  int receive(char* data, size_t count, int timeout);
  size_t size(void) const;
  void flush(void);
  void clear(void);
  void ungetc(const char ch);
};

#endif /* !RECORD_CONNECTION_H */
