#ifndef URG_INFORMATION_WIDGET_H
#define URG_INFORMATION_WIDGET_H

/*!
  \file
  \brief URG パラメータの表示ウィジット

  \author Satofumi KAMIMURA

  $Id: UrgInformationWidget.h 994 2009-06-13 09:29:40Z satofumi $
*/

#include "ui_UrgInformationWidgetForm.h"
#include <memory>


class UrgInformationWidget
  : public QWidget, private Ui::UrgInformationWidgetForm
{
  Q_OBJECT;

  UrgInformationWidget(const UrgInformationWidget& rhs);
  UrgInformationWidget& operator = (const UrgInformationWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void rescanPressed(void);
  void connectPressed(bool connection, const std::string& device);

public:
  UrgInformationWidget(QWidget* parent = 0);
  ~UrgInformationWidget(void);
};

#endif /* !URG_INFORMATION_WIDGET_H */
