#ifndef MULTI_URG_VIEWER_WIDGET_H
#define MULTI_URG_VIEWER_WIDGET_H

/*!
  \file
  \brief 複数 URG のデータ閲覧ツール

  \author Satofumi KAMIMURA

  $Id: MultiUrgViewerWidget.h 994 2009-06-13 09:29:40Z satofumi $
*/

#include <QWidget>
#include <memory>


class UrgStateWidget;
class DrawWidget;


class MultiUrgViewerWidget : public QWidget
{
  Q_OBJECT;

  MultiUrgViewerWidget(const MultiUrgViewerWidget& rhs);
  MultiUrgViewerWidget& operator = (const MultiUrgViewerWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void deleteUrgState(UrgStateWidget* widget);
  void closeEvent(QCloseEvent* event);

public:
  MultiUrgViewerWidget(QWidget* parent = 0);
  ~MultiUrgViewerWidget(void);

  void addUrgState(void);
  DrawWidget* drawWidget(void);

public slots:
  void rescanDevices(void);
};

#endif /* !MULTI_URG_VIEWER_WIDGET_H */
