#ifndef QRK_SURFACE_H
#define QRK_SURFACE_H

/*!
  \file
  \brief サーフェスのインターフェース定義

  \author Satofumi KAMIMURA

  $Id: Surface.h 856 2009-05-11 12:38:20Z satofumi $
*/

#include "Rect.h"


namespace qrk
{
  /*!
    \brief サーフェスのインターフェース定義
  */
  class Surface
  {
  public:
    virtual ~Surface(void)
    {
    }

    virtual bool isValid(void) const = 0;
    virtual Rect<long> rect(void) const = 0;
    virtual void setAlpha(float alpha) = 0;
    virtual float alpha(void) const = 0;
    virtual void draw(const Rect<long>* src, const Rect<long>* dest) = 0;

    // !!!
  };
}

#endif /* !QRK_SURFACE_H */
