#ifndef QRK_SCREEN_H
#define QRK_SCREEN_H

/*!
  \file
  \brief 画面の生成

  \author Satofumi KAMIMURA

  $Id: Screen.h 906 2009-05-19 22:36:51Z satofumi $
*/

#include "Rect.h"
#include <SDL.h>


namespace qrk
{
  class Color;


  /*!
    \brief 画面の生成
  */
  class Screen
  {
    Screen(const Screen& rhs);
    Screen& operator = (const Screen& rhs);

    struct pImpl;
    pImpl* pimpl;

  public:
    Screen(void);
    ~Screen(void);

    const char* what(void) const;

    bool show(Uint32 flags = 0);

    Rect<long> rect(void) const;

    //! 変更は show(), setFullscreen(), toggleFullscreen() 呼び出し時に反映される
    void setWindowSize(size_t width, size_t height);

    //! 変更は show(), setFullscreen(), toggleFullscreen() 呼び出し時に反映される
    void setWindowBpp(size_t bpp);

    void setCaption(const char* caption, const char* icon_caption);
    void setIcon(const SDL_Surface* icon, const Uint8* mask = NULL);

    void setFullscreen(bool on = true);
    bool isFullscreen(void) const;
    void toggleScreen(void);

    void showCursor(bool show_cursor);
    bool isShowCursor(void) const;

    void setClearColor(const Color& color);

    //! SDL_OPENGL が指定されていないと動作しない
    void clear(void);

    static void enter2D(void);
    static void leave2D(void);

    static void setClipArea(const Rect<long>& area);
    static void disableClipArea(void);
  };
}

#endif /* !QRK_SCREEN_H */
