#ifndef QRK_LAYER_H
#define QRK_LAYER_H

/*!
  \file
  \brief 描画レイヤー

  \author Satofumi KAMIMURA

  $Id: Layer.h 912 2009-05-20 14:10:37Z satofumi $
*/

#include "LayerInterface.h"
#include <memory>


namespace qrk
{
  class Component;


  /*!
    \brief 描画レイヤー
  */
  class Layer : public LayerInterface
  {
    Layer(const Layer& rhs);
    Layer& operator = (const Layer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    Layer(void);
    ~Layer(void);

    void clear(void);
    void push_front(Component* component);
    void push_back(Component* component);
    void remove(Component* component);
    void setAlpha(float alpha);
    void draw(void);
  };
}

#endif /* !QRK_LAYER_H */
