/*!
  \file
  \brief ハエ叩き

  \author Satofumi KAMIMURA

  $Id: FlyFlapp.cpp 936 2009-05-29 04:19:26Z satofumi $

  \todo ウィンドウのキャプションを設定する
*/

#include "Audio.h"
#include "Screen.h"
#include "LuaHandler.h"
#include "luabindSystem.h"
#include "luabindGeometry.h"
#include "luabindGui.h"
#include "luabindAudio.h"
#include "luabindFlyFlapp.h"
#include "luabindInit.h"
#include <cstring>

using namespace qrk;


namespace
{
  bool parseArgs(int argc, char *argv[])
  {
    // "--mute" が渡された場合、ミュートとみなす
    bool is_mute = false;
    for (int i = 1; i < argc; ++i) {
      if (! strcmp(argv[i], "--mute")) {
        is_mute = true;
        break;
      }
    }
    return is_mute;
  }


  void initializeLuabind(lua_State* L)
  {
    luabindSystem(L);
    luabindGeometry(L);
    luabindGui(L);
    luabindAudio(L);
    luabindFlyFlapp(L);
  }
}


//! 初期化と Lua スクリプトの実行
int main(int argc, char *argv[])
{
  // 画面の生成
  Screen screen;
  if (! screen.show(SDL_OPENGL)) {
    printf("Screen::show: %s\n", screen.what());
    exit(1);
  }

  // 音源の初期化
  bool is_mute = parseArgs(argc, argv);
  if (! is_mute) {
    Audio audio;
    audio.initialize();
  }

  // Lua の初期化と実行
  lua_State* L = luabindInit();
  initializeLuabind(L);
  LuaHandler::dofile(L, "strict.lua");
  return LuaHandler::dofile(L, "FlyFlapp.lua");
}
