#ifndef QRK_CAMERA_CTRL_H
#define QRK_CAMERA_CTRL_H

/*!
  \file
  \brief カメラ制御

  \author Satofumi KAMIMURA

  $Id: CameraDevice.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "Camera.h"
#include <memory>


namespace qrk
{
  /*!
    \brief カメラ制御
  */
  class CameraDevice : public Camera
  {
  public:
    CameraDevice(void);
    ~CameraDevice(void);

    const char* what(void) const;

    bool connect(void);
    void disconnect(void);

    void setCaptureSize(int width, int height);
    bool capture(const char* file_name = "capture.jpg");

  private:
    CameraDevice(const CameraDevice& rhs);
    CameraDevice& operator = (const CameraDevice& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_CAMERA_CTRL_H */
