/*!
  \file
  \brief CycleTimer の動作サンプル

  \author Satofumi KAMIMURA

  $Id: cycleWait.cpp 1053 2009-06-20 22:52:51Z satofumi $
*/

#include "CycleTimer.h"
#include "ticks.h"
#include "delay.h"
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  CycleTimer cycle_timer;

  int first_ticks = ticks();
  enum { Turns = 100 };
  for (int i = 0; i < Turns; ++i) {
    cout << ticks() << endl;
    delay(cycle_timer.waitMsec());
  }
  int last_ticks = ticks();

  cout << (1000.0 * Turns / (last_ticks - first_ticks)) << " [fps]" << endl;

  return 0;
}
