/*!
  \file
  \brief ConvertStdStringPath のテスト

  \author Satofumi KAMIMURA

  $Id: TestConvertStdStringPath.cpp 1418 2009-10-15 16:26:16Z satofumi $
*/

#include <QString>
#include "TestConvertStdStringPath.h"
#include "ConvertStdStringPath.h"
#include <QSysInfo>

using namespace qrk;
using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestConvertStdStringPath);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestConvertStdStringPath,
                                      "TestConvertStdStringPath");


void TestConvertStdStringPath::toSjisTest(void)
{
  // ASCII 文字から SJIS への変換テスト (変化しないはず)
  const char* ascii_original = "desktop";
  string ascii_converted = toStdStringPath(QString(ascii_original));
  CPPUNIT_ASSERT_EQUAL(string(ascii_original), ascii_converted);

  // UTF-8 から SJIS への変換テスト
  // UTF-8: 30c7, 30b9, 30af, 30c8, 30c3, 30d7 (デスクトップ)
  // SJIS:  8366, 8358, 834e, 8367, 8362, 8376
  QChar utf_original[] =
    { 0x30c7, 0x30b9, 0x30af, 0x30c8, 0x30c3, 0x30d7 };
  string utf_converted = toStdStringPath(QString(utf_original, 6));

#ifdef Q_WS_WIN
  const char expected_sjis[] = {
    0x83, 0x66, 0x83, 0x58, 0x83, 0x4e, 0x83, 0x67, 0x83, 0x62, 0x83, 0x76, 0x0
  };

  CPPUNIT_ASSERT_EQUAL(string(expected_sjis), utf_converted);
#endif
}
