/*!
  \file
  \brief std::string 文字列への変換

  \author Satofumi KAMIMURA

  $Id: ConvertStdStringPath.cpp 1418 2009-10-15 16:26:16Z satofumi $
*/

#include <QString>
#include <QLocale>
#include <QTextCodec>
#include "ConvertStdStringPath.h"

using namespace std;


const string qrk::toStdStringPath(const QString& text)
{
  // 文字コードの変換
  QTextCodec* codec = QTextCodec::codecForLocale();
  if (codec && codec->canEncode(text)) {
    return QString(codec->fromUnicode(text)).toStdString();
  }
  return text.toStdString();
}


const QString qrk::toQtStringPath(const string& text)
{
  QTextCodec* codec = QTextCodec::codecForLocale();
  if (codec) {
    return codec->toUnicode(text.c_str());
  }
  return text.c_str();
}
