#ifndef QRK_MANAGED_TICKS_H
#define QRK_MANAGED_TICKS_H

/*!
  \file
  \brief 時間経過の管理クラス

  \author Satofumi KAMIMURA

  $Id: ManagedTicks.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include <memory>


namespace qrk
{
  //! 時間経過の管理クラス
  class ManagedTicks
  {
  public:
    typedef int (*TicksFunction)(void);

    ManagedTicks(void);
    ~ManagedTicks(void);

    void setTicksFunction(TicksFunction function);

    long ticks(void) const;

    // !!! 速度率の最大、最小を定義できるようにする

    void play(void);
    void pause(void);
    void resume(void);
    void moreFaster(void);
    void moreSlower(void);

  private:
    ManagedTicks(const ManagedTicks& rhs);
    ManagedTicks& operator = (const ManagedTicks& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_MANAGED_TICKS_H */
