#ifndef QRK_MASTER_LABLE_H
#define QRK_MASTER_LABLE_H

/*!
  \file
  \brief ラベル

  \author Satofumi KAMIMURA

  $Id: master_Label.h 940 2009-05-29 21:56:03Z satofumi $
*/

#include "Component.h"
#include <memory>


namespace qrk
{
  class Surface;


  namespace sync_master
  {
    /*!
      \brief ラベル
    */
    class Label : public Component
    {
      Label(const Label& rhs);
      Label& operator = (Label& rhs);

      struct pImpl;
      std::auto_ptr<pImpl> pimpl;

    public:
      explicit Label(Surface& surface);
      ~Label(void);

      Rect<long> rect(void) const;
      void setEventAcceptable(bool acceptable);
      void setAlpha(float alpha);
      void draw(const Rect<long>& area);
    };
  }
}

#endif /* !QRK_LABLE_H */
