#ifndef QRK_MASTER_COLOR_SURFACE_H
#define QRK_MASTER_COLOR_SURFACE_H

/*!
  \file
  \brief 単色サーフェス

  \author Satofumi KAMIMURA

  $Id: master_ColorSurface.h 940 2009-05-29 21:56:03Z satofumi $
*/

#include "Surface.h"
#include <memory>


namespace qrk
{
  class Color;


  namespace sync_master
  {
    /*!
      \brief 単色サーフェス
    */
    class ColorSurface : public Surface
    {
      ColorSurface(const ColorSurface& rhs);
      ColorSurface& operator = (const ColorSurface& rhs);

      struct pImpl;
      std::auto_ptr<pImpl> pimpl;

    public:
      explicit ColorSurface(const Rect<long>& rect, const Color& color);
      ~ColorSurface(void);

      bool isValid(void) const;
      Rect<long> rect(void) const;
      void setAlpha(float alpha);
      float alpha(void) const;
      void draw(const Rect<long>* src, const Rect<long>* dest);
    };
  }
}

#endif /* !QRK_MASTER_COLOR_SURFACE_H */
