#ifndef QRK_SLAVE_LAYER_H
#define QRK_SLAVE_LAYER_H

/*!
  \file
  \brief リモート描画 (クライアント側)

  \author Satofumi KAMIMURA

  $Id: SlaveLayer.h 939 2009-05-29 12:32:03Z satofumi $
*/

#include "LayerInterface.h"
#include "Packet.h"
#include <memory>


namespace qrk
{
  class SlaveLayer : public LayerInterface
  {
    class Component;


    SlaveLayer(const SlaveLayer& rhs);
    SlaveLayer& operator = (SlaveLayer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    SlaveLayer(void);
    ~SlaveLayer(void);

    void setAlpha(float alpha);
    void draw(void);

    void clear(void);
    void push_front(Component* component);
    void push_back(Component* component);
    void remove(Component* component);

    void setPacket(const Packet& packet);
    Component* component(size_t register_id);
  };
}

#endif /* !QRK_SLAVE_LAYER_H */
