#ifndef QRK_MASTER_LAYER_H
#define QRK_MASTER_LAYER_H

/*!
  \file
  \brief リモート描画 (マスター側)

  \author Satofumi KAMIMURA

  $Id: MasterLayer.h 934 2009-05-27 22:28:08Z satofumi $
*/

#include "LayerInterface.h"
#include <memory>


namespace qrk
{
  class Component;


  class MasterLayer : public LayerInterface
  {
    MasterLayer(const MasterLayer& rhs);
    MasterLayer& operator = (MasterLayer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    MasterLayer(void);
    ~MasterLayer(void);

    void setAlpha(float alpha);
    void draw(void);

    void clear(void);
    void push_front(Component* component);
    void push_back(Component* component);
    void remove(Component* component);

    void registerId(Component* component, size_t register_id);
  };
}

#endif /* !QRK_MASTER_LAYER_H */
