/*!
  \file
  \brief シミュレーション・プログラムの動作サンプル

  \author Satofumi KAMIMURA

  $Id: SimulationModel.cpp 1045 2009-06-20 04:44:15Z satofumi $
*/

#include <QApplication>
#include <QThread>
#include <QMainWindow>


namespace
{
  typedef int MainFunction(int argc, char *argv[]);
}


// 関数を起動するためのクラス
class MainThread : public QThread
{
  MainFunction* function_;
  int argc_;
  char **argv_;


public:
  MainThread(MainFunction* function, int argc, char *argv[])
    : function_(function), argc_(argc), argv_(argv)
  {
  }


  void run(void)
  {
    // 指定された関数を呼び出す
    function_(argc_, argv_);
  }
};


int main_program(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  // ユーザプログラムをこのスレッドで実行する
  for (int i = 0; i < 3; ++i) {
    fprintf(stderr, "%d\n", i);
    sleep(1);
  }

  return 0;
}


class SimulationWindow : public QMainWindow
{
  MainThread program_;

public:
  SimulationWindow(MainFunction program, int argc, char *argv[])
    : program_(program, argc, argv)
  {
    // プログラム実行を開始するまでに必要な初期化を全て終わらせること
    // !!! 設定の読み出し
    // !!! シミュレーション内モジュールの位置関係を設定
    // !!! イベント・スケジューラの起動

    program_.start();
  }


  void closeEvent(QCloseEvent* event)
  {
    static_cast<void>(event);
    program_.terminate();
    program_.wait();
  }
};


int main(int argc, char *argv[])
{
  QApplication app(argc, argv);

  SimulationWindow simulator(main_program, argc, argv);
  simulator.show();

  return app.exec();
}
