/*!
  \file
  \brief QThread の動作サンプル

  \author Satofumi KAMIMURA

  $Id: SimpleThread.cpp 1043 2009-06-19 14:51:09Z satofumi $
*/

#include <QApplication>
#include <QThread>


class SimpleThread : public QThread
{
  char ch_;

public:
  SimpleThread(char ch) : ch_(ch)
  {
  }


  void run(void)
  {
    for (int i = 0; i < 5; ++i) {
      fprintf(stderr, "%c", ch_);
      sleep(1);
    }
  }
};


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  SimpleThread thread_a('A');
  SimpleThread thread_b('B');

  thread_a.start();
  thread_b.start();

  thread_a.wait();
  thread_b.wait();
}
