#ifndef QRK_QRK_MAIN_H
#define QRK_QRK_MAIN_H

/*!
  \file
  \brief シミュレーション時の main 置換用

  \author Satofumi KAMIMURA

  $Id: qrk_main.h 1449 2009-10-25 19:30:03Z satofumi $
*/

#include "SimulationWindow.h"
#include <QApplication>


int program_main(int argc, char *argv[]);


int main(int argc, char *argv[])
{
  qrk::ArgsInformation args;
  if (! qrk::SimulationWindow::parseArgs(args, argc, argv)) {
    return 0;
  }
  if (! ((args.type_ == qrk::ExecutionType::Playback) ||
         (args.type_ == qrk::ExecutionType::Monitoring) ||
         args.simulation_)) {

    // 実機実行
    qrk::ExecutionType::object()->setType(args.type_);
    return program_main(argc, argv);
  }

  if (args.type_ == qrk::ExecutionType::Simulation) {
    fprintf(stderr, "simulation.\n");
  } else if (args.type_ == qrk::ExecutionType::Playback) {
    fprintf(stderr, "playback.\n");
  } else if (args.type_ == qrk::ExecutionType::Monitoring) {
    fprintf(stderr, "monitoring.\n");
  }

  // シミュレーション時、プレイバック時
  QApplication app(argc, argv);

  qrk::SimulationWindow simulator(program_main, argc, argv);
  simulator.show();

  return app.exec();
}


#define main program_main

#endif /* !QRK_QRK_MAIN_H */
