#ifndef QRK_OBSTACLE_DEVICE_H
#define QRK_OBSTACLE_DEVICE_H

/*!
  \file
  \brief 物体の操作

  \author Satofumi KAMIMURA

  $Id: Obstacle_device.h 1191 2009-07-30 05:52:49Z satofumi $
*/

#include "Device.h"
#include <memory>

namespace qrk
{
  class Obstacle_device : public Device
  {
    Obstacle_device(void);
    Obstacle_device(const Obstacle_device& rhs);
    Obstacle_device& operator = (const Obstacle_device& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    Obstacle_device(const char* script_file);
    ~Obstacle_device(void);

    void setParameter(const char* type, const char* parameter);
    void activate(void);
    void execute(void);
    size_t nextExecuteInterval(void) const;

    // !!!
  };
}

#endif /* !QRK_OBSTACLE_DEVICE_H */
