#ifndef QRK_TICKS_CONTROL_WIDGET_H
#define QRK_TICKS_CONTROL_WIDGET_H

/*!
  \file
  \brief 時間の管理用ウィジット

  \author Satofumi KAMIMURA

  $Id: TicksControlWidget.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "ui_TicksControlWidgetForm.h"


namespace qrk
{
  //! 時間の進捗管理クラス
  class TicksControlWidget : public QWidget, private Ui::TicksControlWidgetForm
  {
    Q_OBJECT;
  public:
    TicksControlWidget(QWidget* parent = 0);
    ~TicksControlWidget(void);

  signals:
    void quit(void);
    void closed(void);
    void play(void);
    void pause(void);
    void moreFaster(void);
    void moreSlower(void);

  private slots:
    void closeEvent(QCloseEvent* event);

  private:
    TicksControlWidget(const TicksControlWidget& rhs);
    TicksControlWidget& operator = (const TicksControlWidget& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !_TICKS_CONTROL_WIDGET_H */
