#ifndef QRK_SIMULATION_MAIN_H
#define QRK_SIMULATION_MAIN_H

/*!
  \file
  \brief シミュレーション時のメイン関数実行用

  \author Satofumi KAMIMURA

  $Id: SimulationMain.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "EventScheduler.h"
#include <QThread>


/*!
  \brief Quick Robot Development Kit
*/
namespace qrk
{
  typedef int MainFunction(int argc, char *argv[]);


  //! シミュレータ
  class SimulationMain : public QThread
  {
    Q_OBJECT;

  public:
    SimulationMain(MainFunction* function, int argc, char *argv[]);
    ~SimulationMain(void);
    void run(void);

  private:
    friend class SimulationWindow;

    SimulationMain(const SimulationMain& rhs);
    SimulationMain& operator = (const SimulationMain& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

    EventScheduler event_scheduler_;
  };
}

#endif /* !QRK_SIMULATION_MAIN_H */
