#ifndef QRK_ODE_MODEL_H
#define QRK_ODE_MODEL_H

/*!
  \file
  \brief ODE 用のモデル・インターフェース

  \author Satofumi KAMIMURA

  $Id: OdeModel.h 1386 2009-10-09 08:00:11Z satofumi $
*/

#include "Position.h"
#include "Point3d.h"
#include <ode/ode.h>


namespace qrk
{
  //! ODE モデル
  class OdeModel
  {
  public:
    virtual ~OdeModel(void)
    {
    }


    // シミュレータ座標系での位置の設定
    virtual void setPosition(const Position<long>& position,
                             OdeModel* model, bool fixed) = 0;

    // シミュレータ座標系における位置の取得
    virtual Position<long> position(void) = 0;

    // シミュレータ座標系における 3D 位置の設定
    virtual void setPosition3d(const Point3d<long>& position,
                               double ax, double ay, double az,
                               const Angle& angle,
                               OdeModel* model, bool fixed) = 0;

    // シミュレータ座標系における 3D 位置の取得
    // !!! 回転行列を返すように変更する
    virtual void position3d(long& px, long& py, long& pz,
                            double& ax, double& ay, double& az) = 0;

    virtual dBodyID objectId(void) const = 0;
  };
}

#endif /* !QRK_ODE_MODEL_H */
