#ifndef QRK_MODEL_MANAGER_H
#define QRK_MODEL_MANAGER_H

/*!
  \file
  \brief モデルの管理

  \author Satofumi KAMIMURA

  $Id: ModelManager.h 1422 2009-10-18 13:48:05Z satofumi $
*/

#include "Color.h"
#include <ode/ode.h>
#include <set>


namespace qrk
{
  //! モデルの管理
  class ModelManager
  {
  public:
    //! モデルの種類
    typedef enum {
      Box,
      Cylinder,
      Sphere,
    } BodyType;


    //! モデルの管理
    typedef struct {
      BodyType type;
      dBodyID body_id;
      dReal length[3];
      Color color;
      bool obstacle;
    } model_t;

    typedef std::set<const model_t*> Models;

    ModelManager(void);
    ~ModelManager(void);

    void clear(void);
    bool empty(void) const;

    void addBox(model_t* model, const dReal length[]);
    void addCylinder(model_t* model, dReal radius, dReal length);
    void addSphere(model_t* model, dReal radius);
    void remove(const model_t* model);

    bool obstacle(dBodyID id) const;

    const Models models(void) const;

  private:
    ModelManager(const ModelManager& rhs);
    ModelManager& operator = (const ModelManager& rhs);

    struct pImpl;
    pImpl* pimpl;
  };
}

#endif /* !QRK_MODEL_MANAGER_H */
