/*!
  \file
  \brief SCI の送信処理

  \author Satofumi KAMIMURA

  $Id: sci_put.c 1041 2009-06-18 23:11:55Z satofumi $
*/

#include "sci_put.h"
#include "cpu_aki_sh2.h"


void sci_putchar(sci_port port, const char ch)
{
  sci_write(port, &ch, 1);
}


int sci_puts(sci_port port, const char* data)
{
  const char *p;
  for (p = data; *p != '\0'; ++p) {
    ;
  }

  return sci_write(port, data, p - data);
}


int sci_putint(sci_port port, const int value)
{
  char buffer[12] = "12345678901";
  int sign = -1;
  int index = 11;
  int calc_value = value;

  if (calc_value >= 0) {
    // 負の値の方が、表現できる数値が１大きいため
    calc_value = -calc_value;
    sign = +1;
  }

  do {
    buffer[index--] = '0' - calc_value % 10;
    calc_value /= 10;
  } while (calc_value != 0);

  if (sign < 0) {
    buffer[index--] = '-';
  }
  ++index;

  return sci_puts(port, &buffer[index]);
}


int sci_puthex(sci_port port, const unsigned long value, const int byte)
{
  char buffer[] = "12345678";
  unsigned long left_value = value;
  int i;

  for (i = 0; i < 8; ++i) {
    int num = left_value & 0xf;
    buffer[7 - i] = num + ((num <= 9) ? '0' : ('a' - 10));
    left_value >>= 4;
  }
  return sci_puts(port, &buffer[8 - (byte << 1)]);
}
