#ifndef RING_BUFFER_H
#define RING_BUFFER_H

/*!
  \file
  \brief リングバッファ

  \author Satofumi KAMIMURA

  $Id: ring_buffer.h 1041 2009-06-18 23:11:55Z satofumi $
*/


/*!
  \brief リングバッファの管理情報
*/
typedef struct {
  char *buffer;
  int buffer_size;
  int first;
  int last;
} ringBuffer_t;


extern void ring_init(ringBuffer_t *ring,
                      char *buffer, const int shift_length);
extern void ring_clear(ringBuffer_t *ring);
extern int ring_size(ringBuffer_t *ring);
extern int ring_capacity(ringBuffer_t *ring);
extern int ring_putchar(ringBuffer_t *ring, const char ch);
extern int ring_getchar(ringBuffer_t *ring, char *ch);
extern int ring_write(ringBuffer_t *ring, const char *data, int size);
extern int ring_read(ringBuffer_t *ring, char *buffer, int size);

#endif /* ! RING_BUFFER_H */
