/*!
  \file
  \brief 割り込みマスク制御

  \author Satofumi KAMIMURA

  $Id: imask_control.c 1041 2009-06-18 23:11:55Z satofumi $
*/

#include "imask_control.h"


void imask_setMaskLevel(int level)
{
  int srreg;

  level <<= 4;
  level &= 0x00f0;
  asm("stc        sr, %0 ": "=r"(srreg):);
  srreg &= 0xff0f;
  srreg |= level;
  asm("ldc        %0, sr ": :"r"(srreg));
}


/* 割り込みマスクの取得 */
int imask_maskLevel(void)
{
  unsigned short mask;

  asm("stc        sr, %0 ": "=r"(mask):);
  mask &= ~0xff0f;
  mask >>= 4;

  return mask;
}
