#ifndef QRK_PATH_H
#define QRK_PATH_H

/*!
  \file
  \brief 追従処理

  \author Satofumi KAMIMURA

  $Id: path_t.h 1372 2009-10-06 12:59:28Z satofumi $
*/


typedef enum {
  ServoFree,                    //!< サーボフリー
  Stop,
  Line,                         //!< 直線追従
  Line_stop,                    //!< 直線追従 (停止)
  Circle,                       //!< 円弧追従
  Circle_stop,                  //!< 円弧追従 (停止)
  Rotation,                     //!< その場での回転
  Rotation_stop,                //!< その場での回転 (停止)
} PathMode;


//! 追従処理
typedef struct
{
  char reset;
  char reset_offset;
  PathMode mode;                //!< 経路の追従モード
  long follow_radius;           //!< 追従時の曲率 [mm]
  long rotate_direction;       //!< 停止向き(その場での回転、で用いる)
  long circle_radius;        //!< 追従の半径 [mm] (円弧追従、で用いる)
} path_t;

#endif /* !QRK_PATH_H */
