/*!
  \example viewVvSample.cpp

  \brief VV データ内容の表示

  \author Satofumi KAMIMURA

  $Id: viewVvSample.cpp 1437 2009-10-21 16:08:07Z satofumi $
*/

#include "UrgCtrl.h"
#include <cstdlib>
#include <iostream>

using namespace qrk;
using namespace std;


//! main
int main(int argc, char *argv[])
{
  const char device[] = "COM3";
  //const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  vector<string> lines;

  // バージョン情報の取得
  urg.versionLines(lines);
  if (lines.empty()) {
    cerr << "UrgCtrl::versionLines: " << urg.what() << endl;
    exit(1);
  }

  // 出力
  for (vector<string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    cout << *it << endl;
  }

#ifdef MSC
  getchar();
#endif

  return 0;
}
