#ifndef QRK_SCIP_UTILS_H
#define QRK_SCIP_UTILS_H

/*!
  \example ScipUtils.h

  \brief SCIP 2.0 応答の受信

  \author Satofumi KAMIMURA

  $Id: ScipUtils.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include <vector>
#include <string>


namespace qrk {
  class Connection;

  enum {
    ScipTimeout = 200,          //!< [msec]
  };
}


/*!
  \brief SCIP データのデコード

  \param[in] code デコード文字列
  \param[in] byte デコード文字数

  \retval デコード結果
*/
extern int decode(const char code[], int byte);


/*!
  \brief 簡易コマンド送信

  \param[in] con 接続オブジェクト
  \param timeout 受信タイムアウト [msec]
  \param[out] lines 受信データの格納用

  \retval 0 正常終了
  retval < 0 エラー
*/
extern int recvReply(qrk::Connection* con, int timeout,
                     std::vector<std::string>* lines = NULL);

#endif /* !QRK_SCIP_UTILS_H */
