/*!
  \example viewVvSample.cpp

  \brief VV データ内容の表示

  \author Satofumi KAMIMURA

  $Id: viewVvSample.cpp 778 2009-05-05 08:13:45Z satofumi $
*/

#include "mUrgCtrl.h"
#include <iostream>
#include <SDL.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);

  //const char device[] = "COM3";
  const char device[] = "/dev/ttyACM0";

  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // バージョン情報の出力
  vector<string> lines;
  urg.versionLines(lines);
  if (lines.empty()) {
    cerr << "UrgCtrl::versionLines: " << urg.what() << endl;
    exit(1);
  }

  for (vector<string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    cout << *it << endl;
  }

  return 0;
}
