/*!
  \example viewPpSample.cpp

  \brief PP データ内容の表示

  \author Satofumi KAMIMURA

  $Id: viewPpSample.cpp 778 2009-05-05 08:13:45Z satofumi $
*/

#include "mUrgCtrl.h"
#include "RangeSensorParameter.h"
#include <SDL.h>

using namespace qrk;


int main(int argc, char *argv[]) {

  mUrgCtrl urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // パラメータ情報の出力
  RangeSensorParameter parameters = urg.parameter();
  printf("model: %s\n", parameters.model.c_str());
  printf("distance_min: %ld\n", parameters.distance_min);
  printf("distance_max: %ld\n", parameters.distance_max);
  printf("area_total: %d\n", parameters.area_total);
  printf("area_min: %d\n", parameters.area_min);
  printf("area_max: %d\n", parameters.area_max);
  printf("area_front: %d\n", parameters.area_front);
  printf("scan_rpm: %d\n", parameters.scan_rpm);

  return 0;
}
