/*!
  \file
  \brief URG のリセットサンプル

  \author Satofumi KAMIMURA

  $Id: rebootUrg.cpp 1300 2009-09-15 06:36:54Z satofumi $
*/

#include "mUrgCtrl.h"
#include "delay.h"

using namespace qrk;
using namespace std;


static void printVersion(mUrgCtrl& urg)
{
  // バージョン情報の取得
  vector<string> lines;
  urg.versionLines(lines);
  if (lines.empty()) {
    cerr << "UrgCtrl::versionLines: " << urg.what() << endl;
    exit(1);
  }

  // 表示
  for (vector<string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    cout << *it << endl;
  }
}


int main(int argc, char *argv[])
{
  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  mUrgCtrl urg(argc, argv);

  enum {
    RebootTimes = 10,
    RebootMsec = 7000,         /* [msec] */
  };
  for (int i = 0; i < RebootTimes; ++i) {
    if (! urg.connect(device)) {
      cout << "UrgCtrl::connect: " << urg.what() << endl;
      exit(0);
    }

    // バージョン情報の表示
    printVersion(urg);

    // リセット
    urg.reset();

    // 再起動を待つ
    delay(RebootMsec);
  }

  return 0;
}
