/*!
  \example calculateChecksumSample.cpp

  \brief チェックサムの計算サンプル

  \author Satofumi KAMIMURA

  $Id: calculateChecksumSample.cpp 1034 2009-06-17 23:33:28Z satofumi $
*/

#include <cstdio>
#include <cstring>
#include <SDL.h>

namespace
{
  bool checkSum(char* buffer, int size, char actual_sum)
  {
    char expected_sum = 0x00;
    for (int i = 0; i < size; ++i) {
      expected_sum += buffer[i];
    }
    expected_sum = (expected_sum & 0x3f) + 0x30;
#if 1
    if (expected_sum != actual_sum) {
      fprintf(stderr, "expected sum: %c\n", expected_sum);
    }
#endif

    return (expected_sum == actual_sum) ? true : false;
  }
}

int main(int argc, char *argv[])
{
  //char line[] = "MODL:UTM-30LX(Hokuyo Automatic Co.,Ltd.);U";
  //char line[] = "DMIN:23;7";
  //char line[] = "SCAN:600;eRDIR:CCW;8";
  char line[] = "RDIR:CCW;8";
  //char line[] = "02R";

  int n = strlen(line);
  bool ret = checkSum(line,
                      (line[n - 2] == ';') ? n - 2 : n - 1,
                      line[n - 1]);
  printf("%s %s\n", line, (ret) ? "true" : "false");

  return 0;
}
